/***************************************************************

 Simple wrapper to start Win32 console applications without
 showing the console. 
 
 Compile with the free Borland C Builder 5.5 Commandline Tools.
 
 (c) Peter van Eerten, November 24, 2002
 
 ***************************************************************/

#include <windows.h>
#include <stdio.h>

#pragma resource "run.res"

#define MAX_LENGTH 1024

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) 
{
//Declarations for current filename
char filename[MAX_PATH];
char *end, *name;
DWORD len;

//Declarations for new process	
STARTUPINFO si = {sizeof(si)};
PROCESS_INFORMATION pi;
int ret;	
FILE *setupini;
char exe[MAX_LENGTH];

//First get current filename
len=GetModuleFileName(NULL, filename, MAX_PATH);
name=filename+len-1;
end=name;

//Rip off the directory
while (name>filename && *name!='/' && *name!='\\') name--;
if (*name=='/' || *name=='\\') name++;

//Put the INI extension behind the filename
while (*end!='.') end--;
end++; *end='i';
end++; *end='n';
end++; *end='i';
end++; *end='\0';

//Open the INI file
setupini = fopen (name, "r");

//Does the INI file exist?
if (setupini != NULL){
	
	//Yes, get the string from the INI file
	fgets (exe, MAX_LENGTH, setupini);
	
	//Trim any newline off the string
	if (exe[strlen(exe) - 1] == '\n') exe[strlen(exe) - 1] = '\0';

	//Start process without console window
	si.dwFlags=STARTF_USESHOWWINDOW;
	si.wShowWindow=SW_HIDE;
	ret = CreateProcess (NULL, (char*)exe, NULL, NULL, FALSE,
		CREATE_NO_WINDOW, NULL, NULL, &si, &pi);

	fclose(setupini);
	
	//Starting process had problems? Create error.log
	if (ret==0){
		setupini = fopen ("error.log", "w");
		fputs ("ERROR: Could not launch your application!", setupini);
		fclose(setupini);
		MessageBox(NULL, (char*)exe, "Error!", MB_OK | MB_ICONEXCLAMATION);
	}
}
//The INI file does not exist, create error.log
else {
	setupini = fopen ("error.log", "w");
	fputs ("ERROR: Could not find the '", setupini);
	fputs (name, setupini);
	fputs ("' file!", setupini);
	fclose(setupini);
	MessageBox(NULL, "Cannot find the INI file!", "Error!", MB_OK | MB_ICONEXCLAMATION);
}
return (0);
}
