#include <gtk/gtk.h>
#include "visiolib.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

//**************************************************************************

void visio_debug (long indicator)
{
if (indicator == 1) {visio_debugging = 1;printf ("Debugging on.\n");}
else {visio_debugging = 0;printf("Debugging off.\n");}
}

//**************************************************************************

void visio_init()
{
gtk_init (NULL, NULL);
main_window = NULL;
radio_button_group_pointer=1;
menu_list_pointer=1;
sbar_pointer = 1;
canvas_pointer=0;
gc = NULL;
bggc = NULL;
text_fg_color = NULL;
text_bg_color = NULL;
tooltips = gtk_tooltips_new();
if (visio_debugging) printf ("Visio initialized.\n");
}

//**************************************************************************

void visio_exit()
{
if (visio_debugging) printf ("Visio exit.\n");
gtk_exit(0);
}

//**************************************************************************

void visio_focus(long object)
{
gtk_widget_grab_focus(GTK_WIDGET(object));
if (visio_debugging) printf ("Focus set.\n");
}

//**************************************************************************

void window_destroy_callback(GtkWidget *widget,
                                gpointer data )
{
if (visio_debugging) printf ("Destroy event occurred.\n");   //of gtk_main_quit();
visio_exit();
}

//**************************************************************************

void window_delete_callback(GtkWidget *widget,
                                gpointer data )
{
if (widget == main_window)
     {if (visio_debugging) printf ("Destroy event occurred.\n");
      visio_exit();}
else {if (visio_debugging) printf ("Delete event occurred.\n");
      gtk_widget_hide(GTK_WIDGET(widget));}
}

//**************************************************************************

void window_resize_callback(GtkWidget *widget, GtkRequisition *requisition, gpointer data )
{
current_object.object = widget;
current_object.state = V_RESIZED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: window resized.\n");
}

//**************************************************************************

long visio_window(char *title, long xsize, long ysize, long pos)
{
GtkWidget *window;

window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
if (main_window==NULL) main_window = window;
gtk_widget_set_usize (window, xsize, ysize);
gtk_window_set_title (GTK_WINDOW (window), title);
gtk_signal_connect (GTK_OBJECT (window), "delete-event",
                        GTK_SIGNAL_FUNC (window_delete_callback), NULL);
gtk_signal_connect (GTK_OBJECT (window), "destroy",
                        GTK_SIGNAL_FUNC (window_destroy_callback), NULL);
gtk_signal_connect (GTK_OBJECT (window), "size-request",
                        GTK_SIGNAL_FUNC (window_resize_callback), NULL);
gtk_container_set_border_width (GTK_CONTAINER (window), 2);
if (pos<0||pos>2) {printf ("\nIllegal window position! Quitting...\n");gtk_exit(1);}
switch (pos){
case 0: gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_NONE);break;
case 1: gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);break;
case 2: gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_MOUSE);break;
}
gtk_widget_realize(window);

if (visio_debugging) printf ("Main window created.\n");
return ((long)window);
}

//**************************************************************************

long visio_window_resized(long window)
{
if ((long)current_object.object == window && (long)current_object.state == V_RESIZED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

void visio_window_type (long window, long type)
{
if (type) gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);
else gtk_window_set_policy(GTK_WINDOW(window), FALSE, TRUE, FALSE);
if (visio_debugging) printf ("Window type set.\n");
}

//**************************************************************************

void visio_window_color(long widget, long red, long green, long blue)
{
GtkRcStyle *rc_style;
GdkColor color;

rc_style = gtk_rc_style_new ();

color.red = red;
color.green = green;
color.blue = blue;

rc_style->bg[GTK_STATE_NORMAL] = color;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BG;
//Next is needed for notebook widget
rc_style->bg[GTK_STATE_ACTIVE] = color;
rc_style->color_flags[GTK_STATE_ACTIVE] |= GTK_RC_BG;
//Next is needed for label widget
rc_style->fg[GTK_STATE_NORMAL] = color;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG;
//Next is needed for progressbar
rc_style->bg[GTK_STATE_PRELIGHT] = color;
rc_style->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_BG;

gtk_widget_modify_style (GTK_WIDGET(widget), rc_style);
gtk_rc_style_unref (rc_style);

if (visio_debugging) printf ("Widget color set.\n");
}

//**************************************************************************

void visio_font(long object, char *fontname)
{
GdkFont *userfont;
GtkStyle *style;

userfont = gdk_font_load (fontname);	//Returns NULL if the font does not exist
style = gtk_widget_get_style(GTK_WIDGET(object));
style -> font = userfont;

gtk_widget_set_style(GTK_WIDGET(object), style);
if (visio_debugging) printf ("Default font set.\n");
}

//**************************************************************************

long visio_grid(long object, long xsize, long ysize)
{
GtkWidget *table;

table = gtk_table_new(ysize, xsize, TRUE);
gtk_container_add (GTK_CONTAINER (object), table);
gtk_widget_show (table);
if (visio_debugging) printf ("Grid created.\n");
return ((long)table);
}

//**************************************************************************

void visio_hide(long object)
{
if (visio_debugging) printf ("Object hidden.\n");
gtk_widget_hide(GTK_WIDGET(object));
}

//**************************************************************************

void visio_show(long object)
{
if (visio_debugging) printf ("Object shown.\n");
gtk_widget_show(GTK_WIDGET(object));
}

//**************************************************************************

void visio_wait(long indicator)
{
//if (visio_debugging) printf ("Waiting for an event.\n");
if (indicator == 1) {
	while (gtk_events_pending()) gtk_main_iteration();
	gtk_main_iteration_do(TRUE);}
else {gtk_main_iteration_do(FALSE);}
}

//**************************************************************************

void visio_enable(long object)
{
gboolean sens = TRUE;

if (visio_debugging) printf ("Object enabled.\n");
gtk_widget_set_sensitive(GTK_WIDGET(object), sens);
}

//**************************************************************************

void visio_disable(long object)
{
gboolean sens = FALSE;

if (visio_debugging) printf ("Object disabled.\n");
gtk_widget_set_sensitive(GTK_WIDGET(object), sens);
}

//**************************************************************************

void visio_button_click_callback(GtkWidget *widget, gpointer data)
{
current_object.object = widget;
current_object.state = V_CLICKED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: button clicked.\n");
}

//**************************************************************************

long visio_button (long object, long xpos, long ypos, long width, long height, char *title)
{
GtkWidget *button;

button = gtk_button_new_with_label (title);
gtk_table_attach_defaults(GTK_TABLE(object), button, xpos, xpos+width, ypos, ypos+height);
gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (visio_button_click_callback), NULL);
gtk_widget_show(button);
if (visio_debugging) printf ("Button created.\n");
return ((long)button);
}

//**************************************************************************

void visio_button_color(long widget, long fgred, long fggreen, long fgblue, long bgred, long bggreen, long bgblue)
{
GtkRcStyle *rc_style_fg, *rc_style_bg;
GtkWidget *child = GTK_BIN (widget)->child;
GdkColor colorfg;
GdkColor color1, color2, color3;

rc_style_fg = gtk_rc_style_new ();

colorfg.red = fgred;
colorfg.green = fggreen;
colorfg.blue = fgblue;

rc_style_fg->fg[GTK_STATE_NORMAL] = colorfg;
rc_style_fg->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG;
rc_style_fg->fg[GTK_STATE_PRELIGHT] = colorfg;
rc_style_fg->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_FG;
rc_style_fg->fg[GTK_STATE_ACTIVE] = colorfg;
rc_style_fg->color_flags[GTK_STATE_ACTIVE] |= GTK_RC_FG;

gtk_widget_modify_style (GTK_WIDGET(child), rc_style_fg);
gtk_rc_style_unref (rc_style_fg);

rc_style_bg = gtk_rc_style_new ();

color1.red = bgred;
color1.green = bggreen;
color1.blue = bgblue;

if (bgred < 57344) color2.red = bgred + 8192;
else color2.red = 65535;
if (bggreen < 57344) color2.green = bggreen + 8192;
else color2.green = 65535;
if (bgblue < 57344) color2.blue = bgblue + 8192;
else color2.blue = 65535;

if (bgred > 8192) color3.red = bgred - 8192;
else color3.red = 0;
if (bggreen > 8192) color3.green = bggreen - 8192;
else color3.green = 0;
if (bgblue > 8192) color3.blue = bgblue - 8192;
else color3.blue = 0;

rc_style_bg->bg[GTK_STATE_NORMAL] = color1;
rc_style_bg->bg[GTK_STATE_PRELIGHT] = color2;
rc_style_bg->bg[GTK_STATE_ACTIVE] = color3;
rc_style_bg->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BG;
rc_style_bg->color_flags[GTK_STATE_PRELIGHT] |= GTK_RC_BG;
rc_style_bg->color_flags[GTK_STATE_ACTIVE] |= GTK_RC_BG;

gtk_widget_modify_style (GTK_WIDGET(widget), rc_style_bg);
gtk_rc_style_unref (rc_style_bg);

if (visio_debugging) printf ("Widget colors set.\n");
}

//**************************************************************************
// This code was ripped from the GTK tutorial, and adjusted a little bit

GtkWidget *xpm_label_box (GtkWidget *parent, gchar *xpm_filename)
{
GtkWidget *box1, *pixmapwid;
GdkPixmap *pixmap;
GdkBitmap *mask;
GtkStyle *style;

box1 = gtk_hbox_new (FALSE, 0);
style = gtk_widget_get_style(parent);

pixmap = gdk_pixmap_create_from_xpm (parent->window, &mask, &style->bg[GTK_STATE_NORMAL], xpm_filename);
pixmapwid = gtk_pixmap_new (pixmap, mask);

gtk_box_pack_start (GTK_BOX (box1), pixmapwid, FALSE, FALSE, 3);
gtk_widget_show(pixmapwid);

return(box1);
}

//**************************************************************************

long visio_button_pixmap (long object, long xpos, long ypos, long width, long height, char *pix)
{
GtkWidget *button, *box1;

button = gtk_button_new ();
box1 = xpm_label_box(main_window, pix);

gtk_widget_show(box1);
gtk_container_add (GTK_CONTAINER (button), box1);

gtk_table_attach_defaults(GTK_TABLE(object), button, xpos, xpos+width, ypos, ypos+height);
gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (visio_button_click_callback), NULL);
gtk_widget_show(button);
if (visio_debugging) printf ("Button created.\n");
return ((long)button);
}

//**************************************************************************

long visio_button_clicked (long button)
{
if ((long)current_object.object == button && (long)current_object.state == V_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

long visio_toggle (long object, long xpos, long ypos, long width, long height, char *title)
{
GtkWidget *button;
button = gtk_toggle_button_new_with_label (title);
gtk_table_attach_defaults(GTK_TABLE(object), button, xpos, xpos+width, ypos, ypos+height);
gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (visio_button_click_callback), NULL);
gtk_widget_show(button);
if (visio_debugging) printf ("Toggle button created.\n");
return ((long)button);
}

//**************************************************************************

long visio_toggle_pixmap (long object, long xpos, long ypos, long width, long height, char *pix)
{
GtkWidget *button, *box1;

button = gtk_toggle_button_new ();
box1 = xpm_label_box(main_window, pix);

gtk_widget_show(box1);
gtk_container_add (GTK_CONTAINER (button), box1);

gtk_table_attach_defaults(GTK_TABLE(object), button, xpos, xpos+width, ypos, ypos+height);
gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (visio_button_click_callback), NULL);
gtk_widget_show(button);
if (visio_debugging) printf ("Toggle button created.\n");
return ((long)button);
}

//**************************************************************************

void visio_toggle_set_status (long toggle, int state)
{
gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle), state);
if (visio_debugging) printf ("Toggle button state set.\n");
}

//**************************************************************************

long visio_toggle_get_status (long toggle)
{
if (visio_debugging) printf("Toggle button state fetched.\n");
if (GTK_TOGGLE_BUTTON (toggle)->active) return(1);
else return (0);
}

//**************************************************************************

long visio_check (long object, long xpos, long ypos, long width, long height, char *title)
{
GtkWidget *button;
button = gtk_check_button_new_with_label (title);
gtk_table_attach_defaults(GTK_TABLE(object), button, xpos, xpos+width, ypos, ypos+height);
//gtk_signal_connect (GTK_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (visio_button_click_callback), NULL);
gtk_widget_show(button);
if (visio_debugging) printf ("Check button created.\n");
return ((long)button);
}

//**************************************************************************

void visio_check_set_status (long check, int state)
{
gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), state);
if (visio_debugging) printf ("Check button state set.\n");
}

//**************************************************************************

long visio_check_get_status (long check)
{
if (visio_debugging) printf("Check button state fetched.\n");
if (GTK_TOGGLE_BUTTON (check)->active) return(1);
else return (0);
}

//**************************************************************************

void visio_textbox_click_callback(GtkWidget *widget, gpointer function)
{
current_object.object = widget;
current_object.state = V_ACTIVATED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: textbox activated.\n");
}

//**************************************************************************

long visio_textbox (long object, long xpos, long ypos, long width, long height)
{
GtkWidget *textbox;

textbox = gtk_entry_new();
gtk_table_attach_defaults(GTK_TABLE(object), textbox, xpos, xpos+width, ypos, ypos+height);
gtk_signal_connect (GTK_OBJECT (textbox), "activate", GTK_SIGNAL_FUNC (visio_textbox_click_callback), NULL);
gtk_widget_show(textbox);
if (visio_debugging) printf ("Textbox created.\n");
return ((long)textbox);
}

//**************************************************************************

long visio_textbox_activated (long textbox)
{
if ((long)current_object.object == textbox && (long)current_object.state == V_ACTIVATED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

void visio_textbox_set_text (long object, char *text)
{
gtk_entry_set_text (GTK_ENTRY(object), text);
if (visio_debugging) printf ("Text in textbox set.\n");
}

//**************************************************************************

char *visio_textbox_get_text (long object)
{
if (visio_debugging) printf ("Text in textbox fetched.\n");
return (gtk_entry_get_text (GTK_ENTRY(object)));
}

//**************************************************************************

void visio_textbox_color(long textbox, long fgred, long fggreen, long fgblue, long bgred, long bggreen, long bgblue)
{
GtkRcStyle *rc_style;
GdkColor colorfg, colorbg;

rc_style = gtk_rc_style_new ();

colorfg.red = fgred;
colorfg.green = fggreen;
colorfg.blue = fgblue;

rc_style->fg[GTK_STATE_NORMAL] = colorfg;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_FG;
rc_style->text[GTK_STATE_NORMAL] = colorfg;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_TEXT;

colorbg.red = bgred;
colorbg.green = bggreen;
colorbg.blue = bgblue;

rc_style->base[GTK_STATE_NORMAL] = colorbg;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BASE;
rc_style->bg[GTK_STATE_NORMAL] = colorbg;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BG;

gtk_widget_modify_style (GTK_WIDGET(textbox), rc_style);
gtk_rc_style_unref (rc_style);
if (visio_debugging) printf ("Widget colors set.\n");
}

//**************************************************************************

long visio_label (long object, long xpos, long ypos, long width, long height, char *text)
{
GtkWidget *label;

label = gtk_label_new(text);
gtk_table_attach_defaults(GTK_TABLE(object), label, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show(label);
if (visio_debugging) printf ("Label created.\n");
return ((long)label);
}

//**************************************************************************

void visio_label_set_text (long object, char *text)
{
gtk_label_set_text(GTK_LABEL(object), text);
if (visio_debugging) printf ("Text in label set.\n");
}

//**************************************************************************

char *visio_label_get_text (long object)
{
gchar *text;

if (GTK_IS_LABEL (object)){
	gtk_label_get (GTK_LABEL (object), &text);
	if (visio_debugging) printf ("Text in label fetched.\n");
}
return(text);
}

//**************************************************************************

void visio_label_align (long object, double xalignment, double yalignment)
{
if (xalignment<0||xalignment>1){printf ("\nIllegal x-alignment value! Quitting...\n");gtk_exit(1);}
if (yalignment<0||yalignment>1){printf ("\nIllegal y-alignment value! Quitting...\n");gtk_exit(1);}

gtk_misc_set_alignment(GTK_MISC(object), xalignment, yalignment);

if (visio_debugging) printf ("Text in label aligned.\n");
}

//**************************************************************************

long visio_radio (long grid, long list, long xpos, long ypos, long width, long height, char *text)
{
GtkWidget *radio;

if (list<1||list>radio_button_group_pointer){
        printf ("\nIllegal border group reference! Quitting...\n");
        gtk_exit(1);}

if (radio_button_group[list]==NULL)
        {radio = gtk_radio_button_new_with_label(NULL, text);
        radio_button_group[radio_button_group_pointer]=gtk_radio_button_group(GTK_RADIO_BUTTON(radio));
        last_defined_radio_button[radio_button_group_pointer] = radio;
        radio_button_group_pointer++;
        }

else {  radio = gtk_radio_button_new_with_label(gtk_radio_button_group (GTK_RADIO_BUTTON(last_defined_radio_button[list])),text);
        last_defined_radio_button[list] = radio;}

gtk_table_attach_defaults(GTK_TABLE(grid), radio, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show(radio);

if (visio_debugging) printf ("Radio button created.\n");
return ((long)radio);
}

//**************************************************************************

void visio_radio_set_status (long radio, int state)
{
gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radio), state);
if (visio_debugging) printf ("Radio button state set.\n");
}

//**************************************************************************

long visio_radio_get_status (long radio)
{
if (visio_debugging) printf("Radio button state fetched.\n");
if (GTK_TOGGLE_BUTTON (radio)->active) return(1);
else return (0);
}

//**************************************************************************

void visio_click_callback(GtkWidget *widget, gpointer object)
{
current_object.object = object;
current_object.state = V_CHANGED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: combobox clicked.\n");
}

//**************************************************************************

long visio_combobox (long grid, long list, long xpos, long ypos, long width, long height)
{
GtkWidget *combobox;

combobox = gtk_combo_new();
gtk_table_attach_defaults(GTK_TABLE(grid), combobox, xpos, xpos+width, ypos, ypos+height);
gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combobox)->entry), "changed", GTK_SIGNAL_FUNC (visio_click_callback), GTK_OBJECT(combobox));
gtk_combo_set_popdown_strings(GTK_COMBO(combobox), listings[list]);
gtk_widget_show(combobox);
if (visio_debugging) printf ("Combobox created.\n");
return ((long)combobox);
}

//**************************************************************************

long visio_combobox_clicked (long combobox)
{
if ((long)current_object.object == combobox && (long)current_object.state == V_CHANGED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

void visio_list (long list, char *item)
{
listings[list] =  g_list_append(listings[list], item);
if (visio_debugging) printf("List item added.\n");
}

//**************************************************************************

void visio_combobox_set_text (long object, char *text)
{
gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(object)->entry), text);
if (visio_debugging) printf("Text in combobox set.\n");
}

//**************************************************************************

char *visio_combobox_get_text (long object)
{
if (visio_debugging) printf ("Text in combobox fetched.\n");
return (gtk_entry_get_text (GTK_ENTRY(GTK_COMBO(object)->entry)));
}

//**************************************************************************

void menuitem_response(GtkWidget *widget, gpointer object)
{
current_object.object = object;
current_object.state = V_ACTIVATED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: menu item clicked.\n");
}

//**************************************************************************

long visio_menu_bar (long grid, long xpos, long ypos, long width, long height)
{
GtkWidget *menu_bar;

menu_bar = gtk_menu_bar_new ();
gtk_table_attach_defaults(GTK_TABLE(grid), menu_bar, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (menu_bar);
if (visio_debugging) printf("Menubar created.\n");
return ((long)menu_bar);
}

//**************************************************************************

long visio_menu_list (long list, char *label)
{
GtkWidget *menu, *menu_item;

if (list<1||list>menu_list_pointer){
        printf ("\nIllegal menu list reference! Quitting...\n");
        gtk_exit(1);}

if (menu_list[list]==NULL){
        menu = gtk_menu_new ();
        menu_list[menu_list_pointer] = menu;
        menu_list_pointer++;}

menu_item = gtk_menu_item_new_with_label(label);
gtk_signal_connect_object(GTK_OBJECT (menu_item), "activate", GTK_SIGNAL_FUNC (menuitem_response), GTK_OBJECT (menu_item));
gtk_menu_append (GTK_MENU (menu_list[list]),menu_item);
gtk_widget_show (menu_item);
if (visio_debugging) printf("Menulist item added.\n");
return ((long)menu_item);
}

//**************************************************************************

void visio_menu_list_color(long list, long red, long green, long blue)
{
GtkRcStyle *rc_style;
GdkColor color;

rc_style = gtk_rc_style_new ();

color.red = red;
color.green = green;
color.blue = blue;

rc_style->base[GTK_STATE_NORMAL] = color;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BASE;
rc_style->bg[GTK_STATE_NORMAL] = color;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BG;

gtk_widget_modify_style (GTK_WIDGET(menu_list[list]), rc_style);
gtk_rc_style_unref (rc_style);
if (visio_debugging) printf ("Background color set.\n");
}


//**************************************************************************

void visio_menu_connect (long menu_bar, long list, char *title, long align)
{
GtkWidget *menu_title;

menu_title = gtk_menu_item_new_with_label(title);
gtk_widget_show (menu_title);

gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_title), menu_list[list]);
gtk_menu_bar_append (GTK_MENU_BAR (menu_bar), menu_title);
if (align==1)gtk_menu_item_right_justify (GTK_MENU_ITEM (menu_title));
if (visio_debugging) printf("Menubar and menulist connected.\n");
}

//**************************************************************************

static gint popup_show(GtkWidget *widget, GdkEvent *event)
{
//g_return_val_if_fail (widget != NULL, FALSE);
//g_return_val_if_fail (GTK_IS_MENU (widget), FALSE);
//g_return_val_if_fail (event != NULL, FALSE);

if (event->type == GDK_BUTTON_PRESS) {
  GdkEventButton *bevent = (GdkEventButton *) event;
  if (bevent->button == 3) {
	gtk_menu_popup (GTK_MENU (widget), NULL, NULL, NULL, NULL, bevent->button, bevent->time);
	return TRUE;}
}
return FALSE;
}

//**************************************************************************

void visio_menu_popup_connect(long object, long list)
{
gtk_signal_connect_object((GtkObject*)object, "button-press-event", GTK_SIGNAL_FUNC(popup_show), GTK_OBJECT(menu_list[list]));
if (visio_debugging) printf("Object and menulist connected.\n");
}

//**************************************************************************

long visio_menu_clicked (long menu_item)
{
if ((long)current_object.object == menu_item && (long)current_object.state == V_ACTIVATED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

void visio_menu_separator(long list)
{
GtkWidget *menu, *menu_item;

if (list<1||list>menu_list_pointer){
        printf ("\nIllegal menu list reference! Quitting...\n");
        gtk_exit(1);}

if (menu_list[list]==NULL){
        menu = gtk_menu_new ();
        menu_list[menu_list_pointer] = menu;
        menu_list_pointer++;}

menu_item = gtk_menu_item_new();
gtk_menu_append (GTK_MENU (menu_list[list]), menu_item);
gtk_widget_show (menu_item);
if (visio_debugging) printf("Menu separator item added.\n");
}

//**************************************************************************

long visio_edit (long object, long xpos, long ypos, long width, long height)
{
GtkWidget *edit, *vscroll;
GtkAdjustment *hadj, *vadj;

hadj = NULL;
vadj = NULL;

edit = gtk_text_new(hadj, vadj);
gtk_text_set_adjustments(GTK_TEXT(edit), hadj, vadj);
gtk_table_attach_defaults(GTK_TABLE(object), edit, xpos, xpos+width-1, ypos, ypos+height);
gtk_text_set_word_wrap(GTK_TEXT(edit),TRUE);      //defaults to word wrap, not line wrap
gtk_text_set_editable(GTK_TEXT(edit),TRUE);       //defaults to edit-mode
gtk_widget_show (edit);
gtk_text_thaw(GTK_TEXT(edit));						//be sure to dynamic update the widget

vscroll = gtk_vscrollbar_new (GTK_TEXT(edit)->vadj);
gtk_table_attach_defaults(GTK_TABLE(object), vscroll, xpos+width-1, xpos+width, ypos, ypos+height);
gtk_widget_show (vscroll);

if (visio_debugging) printf ("Edit created.\n");
return ((long)edit);
}

//**************************************************************************

void visio_edit_editable(long object, long flag)
{
gtk_text_set_editable(GTK_TEXT(object),flag);
if (visio_debugging) printf ("Editable flag changed.\n");
}

//**************************************************************************

void visio_edit_set_cursor(long object, long pos)
{
gtk_text_set_point(GTK_TEXT(object),pos);
if (visio_debugging) printf ("Cursor set.\n");
}

//**************************************************************************

long visio_edit_get_cursor(long object)
{
if (visio_debugging) printf ("Cursor fetched.\n");
return (gtk_text_get_point(GTK_TEXT(object)));
}

//**************************************************************************

long visio_edit_length(long object)
{
if (visio_debugging) printf ("Edit content length fetched.\n");
return (gtk_text_get_length(GTK_TEXT(object)));
}

//**************************************************************************

void visio_edit_set_text (long object, char *font, char *tekst)
{
//text_fg_color and text_bg_color are global -> see visiolib.h for declaration
GdkFont *specified_font;

if (strcmp(font,"default")==0||strcmp(font,"")==0)specified_font=NULL;
else specified_font = gdk_font_load (font);
gtk_text_insert(GTK_TEXT(object), specified_font, text_fg_color, text_bg_color, tekst, -1);
if (visio_debugging) printf ("Text in edit set.\n");
}

//**************************************************************************

char *visio_edit_get_text (long object)
{
if (visio_debugging) printf ("Text in edit fetched.\n");
return (gtk_editable_get_chars(GTK_EDITABLE(object), 0,-1));
}

//**************************************************************************

long visio_edit_del_text (long object, long amount)
{
if (visio_debugging) printf ("Text in edit deleted.\n");
return (gtk_text_forward_delete(GTK_TEXT(object),amount));
}

//**************************************************************************

void visio_edit_fg_color(long red, long green, long blue)
{
text_fg_color = (GdkColor*) g_malloc (sizeof(GdkColor));
text_fg_color->red   = red;
text_fg_color->green = green;
text_fg_color->blue  = blue;
gdk_color_alloc(gdk_colormap_get_system(), text_fg_color);
if (visio_debugging) printf ("Foreground text color set.\n");
//g_free(color);
}

//**************************************************************************

void visio_edit_bg_color(long red, long green, long blue)
{
text_bg_color = (GdkColor*) g_malloc (sizeof(GdkColor));
text_bg_color->red   = red;
text_bg_color->green = green;
text_bg_color->blue  = blue;
gdk_color_alloc(gdk_colormap_get_system(), text_bg_color);
if (visio_debugging) printf ("Background text color set.\n");
//g_free(color);
}

//**************************************************************************

void visio_edit_field_color(long widget, long red, long green, long blue)
{
GtkRcStyle *rc_style;
GdkColor wcolor;

rc_style = gtk_rc_style_new ();
wcolor.red = red;
wcolor.green = green;
wcolor.blue = blue;

rc_style->base[GTK_STATE_NORMAL] = wcolor;
rc_style->color_flags[GTK_STATE_NORMAL] |= GTK_RC_BASE;
	
gtk_widget_modify_style (GTK_WIDGET(widget), rc_style);
gtk_rc_style_unref (rc_style);
if (visio_debugging) printf ("Field color set.\n");
}

//**************************************************************************

long visio_frame (long object, long xpos, long ypos, long width, long height, long style)
{
GtkWidget *frame;

frame = gtk_frame_new(NULL);
if (style<0||style>4){printf ("\nIllegal style value! Quitting...\n");gtk_exit(1);}
switch (style){
case 0: gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_NONE);break;
case 1: gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_IN);break;
case 2: gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_OUT);break;
case 3: gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_ETCHED_IN);break;
case 4: gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_ETCHED_OUT);break;
}
gtk_table_attach_defaults(GTK_TABLE(object), frame, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (frame);
if (visio_debugging) printf ("Frame created.\n");
return ((long)frame);
}

//**************************************************************************

void visio_frame_set_text (long object, char *label)
{
gtk_frame_set_label(GTK_FRAME(object), label );
if (visio_debugging) printf ("Text in frame set.\n");
}

//**************************************************************************

long visio_spin (long grid, long xpos, long ypos, long width, long height)
{
GtkWidget *spin;

spin = gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(0,0,99,1,10,0)),0,0);
gtk_table_attach_defaults(GTK_TABLE(grid), spin, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (spin);
if (visio_debugging) printf ("Spin button created.\n");
return ((long)spin);
}

//**************************************************************************

void visio_spin_set(long spin, long value, long lower, long upper, long inc)
{
GtkObject *spin_set;

spin_set = gtk_adjustment_new(value, lower, upper, inc, 0, 0);
gtk_spin_button_configure(GTK_SPIN_BUTTON(spin), GTK_ADJUSTMENT(spin_set), 0, 0);
if (visio_debugging) printf ("Spin button configured.\n");
}

//**************************************************************************

long visio_spin_get(long spin)
{
if (visio_debugging) printf ("Value in spin button fetched.\n");
return(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));
}

//**************************************************************************

static gint v_canvas_configure_event(GtkWidget *widget, GdkEventConfigure *event)
{
int i;

for (i = 1; i <= canvas_pointer ; i++){

if (used_canvas[i].pixmap) gdk_pixmap_unref(used_canvas[i].pixmap);

used_canvas[i].pixmap = gdk_pixmap_new(used_canvas[i].area->window, used_canvas[i].area->allocation.width,
	used_canvas[i].area->allocation.height, -1);
if (bggc==NULL){gdk_draw_rectangle (used_canvas[i].pixmap, used_canvas[i].area->style->white_gc, TRUE, 0, 0,
	used_canvas[i].area->allocation.width, used_canvas[i].area->allocation.height);}
else {gdk_draw_rectangle (used_canvas[i].pixmap, bggc, TRUE, 0, 0,
    used_canvas[i].area->allocation.width, used_canvas[i].area->allocation.height);}
}
return (TRUE);
}

//**************************************************************************

static gint v_canvas_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
int i;

for (i=1; i <= canvas_pointer; i++){
if (used_canvas[i].pixmap) {
		gdk_draw_pixmap(used_canvas[i].area->window, used_canvas[i].area->style->fg_gc[GTK_WIDGET_STATE (used_canvas[i].area)],
		used_canvas[i].pixmap, event->area.x, event->area.y,
		event->area.x, event->area.y, event->area.width+1, event->area.height+1);}
}
return (FALSE);
}

//**************************************************************************

void v_canvas_button_press(GtkWidget *widget, GdkEventButton *event)
{
//To check which button: (event->button == 1) is left button
current_object.object = widget;
current_object.state = V_CLICKED;
current_object.mousex = event->x;
current_object.mousey = event->y;
if (visio_debugging) printf ("Callback reached: canvas clicked.\n");
}

//**************************************************************************

long visio_canvas(long grid, long xpos, long ypos, long width, long height)
{
canvas_pointer++;
used_canvas[canvas_pointer].area = gtk_drawing_area_new();
gtk_widget_set_events (used_canvas[canvas_pointer].area,GDK_EXPOSURE_MASK|GDK_LEAVE_NOTIFY_MASK| GDK_BUTTON_PRESS_MASK
			 | GDK_POINTER_MOTION_MASK | GDK_POINTER_MOTION_HINT_MASK);

gtk_signal_connect (GTK_OBJECT(used_canvas[canvas_pointer].area),"expose-event",(GtkSignalFunc)v_canvas_expose_event, NULL);
gtk_signal_connect (GTK_OBJECT(used_canvas[canvas_pointer].area),"configure-event",(GtkSignalFunc)v_canvas_configure_event, NULL);
gtk_signal_connect (GTK_OBJECT(used_canvas[canvas_pointer].area),"button-press-event",(GtkSignalFunc)v_canvas_button_press, NULL);

gtk_table_attach_defaults(GTK_TABLE(grid), used_canvas[canvas_pointer].area, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (used_canvas[canvas_pointer].area);

if (visio_debugging) printf ("Drawing area created.\n");
return (canvas_pointer);
}

//**************************************************************************

long visio_canvas_clicked (long canvas)
{
if ((GtkWidget*)current_object.object == (used_canvas[canvas].area) && (long)current_object.state == V_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

long visio_canvas_width(long which)
{
if (visio_debugging) printf ("Canvas width fetched.\n");
return( used_canvas[which].area->allocation.width);
}

//**************************************************************************

long visio_canvas_height(long which)
{
if (visio_debugging) printf ("Canvas height fetched.\n");
return( used_canvas[which].area->allocation.height);
}

//**************************************************************************

void visio_canvas_rect(long which, long xpos, long ypos, long width, long height, long flag)
{
GdkRectangle rect;

if (used_canvas[which].pixmap != NULL){

rect.x = xpos;
rect.y = ypos;
rect.width = width;
rect.height = height;

if (gc==NULL)gdk_draw_rectangle (used_canvas[which].pixmap, used_canvas[which].area->style->black_gc, (flag && 1), rect.x, rect.y, rect.width, rect.height);
else gdk_draw_rectangle (used_canvas[which].pixmap, gc, (flag && 1), rect.x, rect.y, rect.width, rect.height);
gtk_widget_draw (used_canvas[which].area, &rect);
if (visio_debugging) printf ("Rectangle drawn.\n");
}
}

//**************************************************************************

void visio_canvas_line(long which, long xstart, long ystart, long xend, long yend)
{
GdkRectangle rect;

if (used_canvas[which].pixmap != NULL){

if (xstart<xend)rect.x = xstart;
else rect.x = xend;
if (ystart<yend)rect.y = ystart;
else rect.y = yend;
rect.width = abs(xend-xstart);
rect.height = abs(yend-ystart);

if (gc==NULL){gdk_draw_line(used_canvas[which].pixmap, used_canvas[which].area->style->black_gc, xstart, ystart, xend, yend);}
else gdk_draw_line(used_canvas[which].pixmap, gc, xstart, ystart, xend, yend);
gtk_widget_draw (used_canvas[which].area, &rect);
if (visio_debugging) printf ("Line drawn.\n");
}
}

//**************************************************************************

void visio_canvas_circle(long which, long xpos, long ypos, long width, long height, long flag)
{
GdkRectangle rect;

if (used_canvas[which].pixmap != NULL){

rect.x = xpos-width;
rect.y = ypos-height;
rect.width = 2*width;
rect.height = 2*height;

if (gc==NULL)gdk_draw_arc (used_canvas[which].pixmap, used_canvas[which].area->style->black_gc, (flag && 1), xpos-width, ypos-height, 2*width, 2*height, 0, 360*64);
else gdk_draw_arc (used_canvas[which].pixmap, gc, (flag && 1), xpos-width, ypos-height, 2*width, 2*height, 0, 360*64);
gtk_widget_draw (used_canvas[which].area, &rect);
if (visio_debugging) printf ("Circle drawn.\n");
}
}

//**************************************************************************

void visio_canvas_plot(long which, long xpos, long ypos)
{
GdkRectangle rect;

if (used_canvas[which].pixmap != NULL){

rect.x = xpos;
rect.y = ypos;
rect.width = xpos+1;
rect.height = ypos+1;

if (gc==NULL) gdk_draw_point (used_canvas[which].pixmap,used_canvas[which].area->style->black_gc, xpos, ypos);
else gdk_draw_point (used_canvas[which].pixmap,gc, xpos, ypos);
gtk_widget_draw (used_canvas[which].area, &rect);
if (visio_debugging) printf ("Point drawn.\n");
}
}

//**************************************************************************

void visio_canvas_fg_color(long red, long green, long blue)
{
GdkColor *color = NULL;

if (canvas_pointer==0){printf ("\nNo canvas found! Quitting...\n");gtk_exit(1);}
color = (GdkColor*) g_malloc (sizeof(GdkColor));
gc = gdk_gc_new(used_canvas[canvas_pointer].area->window);
gdk_gc_copy(gc,used_canvas[canvas_pointer].area->style->white_gc);

color->red   = red;
color->green = green;
color->blue  = blue;

gdk_color_alloc(gdk_colormap_get_system(), color);
gdk_gc_set_foreground(gc, color);
if (visio_debugging) printf ("Foreground canvas color set.\n");
g_free(color);
}

//**************************************************************************

void visio_canvas_bg_color(long red, long green, long blue)
{
GdkColor *color = NULL;

if (canvas_pointer==0){printf ("\nNo canvas found! Quitting...\n");gtk_exit(1);}
color = (GdkColor*) g_malloc (sizeof(GdkColor));
bggc = gdk_gc_new(used_canvas[canvas_pointer].area->window);
gdk_gc_copy(bggc,used_canvas[canvas_pointer].area->style->white_gc);

color->red   = red;
color->green = green;
color->blue  = blue;

gdk_color_alloc(gdk_colormap_get_system(), color);
gdk_gc_set_foreground(bggc, color);
if (visio_debugging) printf ("Background canvas color set.\n");
g_free(color);
}

//**************************************************************************

void visio_canvas_clear(long which)
{
GdkRectangle rect;

if (used_canvas[which].pixmap != NULL){

rect.x = 0;
rect.y = 0;
rect.width = used_canvas[which].area->allocation.width;
rect.height = used_canvas[which].area->allocation.height;

if (bggc==NULL){gdk_draw_rectangle (used_canvas[which].pixmap, used_canvas[which].area->style->white_gc, TRUE, 0, 0,
		      used_canvas[which].area->allocation.width, used_canvas[which].area->allocation.height);}
else {gdk_draw_rectangle (used_canvas[which].pixmap, bggc, TRUE, 0, 0,
		      used_canvas[which].area->allocation.width, used_canvas[which].area->allocation.height);}
gtk_widget_draw (used_canvas[which].area, &rect);
if (visio_debugging) printf ("Canvas cleared.\n");
}
}

//**************************************************************************

long visio_canvas_mousex(long canvas)
{
if (visio_debugging) printf ("Mouse x coordinate fetched.\n");
return (current_object.mousex);
}

//**************************************************************************

long visio_canvas_mousey(long canvas)
{
if (visio_debugging) printf ("Mouse y coordinate fetched.\n");
return (current_object.mousey);
}

//**************************************************************************

void visio_canvas_text (long which, char *font, long xpos, long ypos, char *tekst)
{
GdkFont *specified_font;
GdkRectangle rect;
int i;

if (used_canvas[which].pixmap != NULL){

if (strcmp(font,"default")==0||strcmp(font,"")==0)specified_font=NULL;
else specified_font = gdk_font_load (font);

if (gc==NULL)gdk_draw_string (used_canvas[which].pixmap, specified_font, used_canvas[which].area->style->black_gc, xpos, ypos, tekst);
else gdk_draw_string (used_canvas[which].pixmap, specified_font, gc, xpos, ypos, tekst);

gtk_widget_draw (used_canvas[which].area, &rect);

//Needed for Win32 GTK
for (i=1; i <= canvas_pointer; i++){
gdk_draw_pixmap(used_canvas[i].area->window, used_canvas[i].area->style->fg_gc[GTK_WIDGET_STATE (used_canvas[i].area)],
		used_canvas[i].pixmap, 0, 0, 0, 0,
		  used_canvas[i].area -> allocation.width, used_canvas[i].area -> allocation.height);}

if (visio_debugging) printf ("Text in canvas drawn.\n");
}
}

//**************************************************************************

void visio_canvas_popup_connect(long object, long list)
{
gtk_signal_connect_object((GtkObject*)used_canvas[object].area, "button-press-event", GTK_SIGNAL_FUNC(popup_show), GTK_OBJECT(menu_list[list]));
if (visio_debugging) printf("Canvas and menulist connected.\n");
}

//**************************************************************************

void visio_canvas_del(long which)
{
int i;

if ((which > 0)&&(which <= canvas_pointer)){

  //Scroll the elements in the array
  for (i = which; i < canvas_pointer; i++){
  used_canvas[i].pixmap = used_canvas[i + 1].pixmap;
  used_canvas[i].area = used_canvas[i + 1].area;
  }
  //Clear the last element
  used_canvas[canvas_pointer].area = NULL;
  used_canvas[canvas_pointer].pixmap = NULL;

  //Decrease global pointer
  canvas_pointer--;
  if (visio_debugging) printf("Canvas deleted.\n");
}
}

//**************************************************************************

void visio_ok_click_callback(GtkWidget *widget, gpointer object)
{
current_object.object = object;
current_object.state = V_OK_CLICKED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: OK button clicked.\n");
}

//**************************************************************************

void visio_cancel_click_callback(GtkWidget *widget, gpointer object)
{
current_object.object = object;
current_object.state = V_CANCEL_CLICKED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: CANCEL button clicked.\n");
}

//**************************************************************************

void visio_help_click_callback(GtkWidget *widget, gpointer object)
{
current_object.object = object;
current_object.state = V_HELP_CLICKED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: HELP button clicked.\n");
}

//**************************************************************************

long visio_file(char *title)
{
GtkWidget *fileselect;

fileselect = gtk_file_selection_new(title);
gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fileselect)->ok_button),
				"clicked",GTK_SIGNAL_FUNC(visio_ok_click_callback), GTK_OBJECT(fileselect));
gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fileselect)->cancel_button),
				"clicked",GTK_SIGNAL_FUNC(visio_cancel_click_callback), GTK_OBJECT(fileselect));
if (visio_debugging) printf ("File selection dialog created.\n");
return ((long)fileselect);
}

//**************************************************************************

long visio_file_ok_clicked (long filesel)
{
if ((long)current_object.object == filesel && (long)current_object.state == V_OK_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

long visio_file_cancel_clicked (long filesel)
{
if ((long)current_object.object == filesel && (long)current_object.state == V_CANCEL_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

char* visio_file_get(long object)
{
if (visio_debugging) printf ("File from file selection dialog fetched.\n");
return(gtk_file_selection_get_filename(GTK_FILE_SELECTION(object)));
}

//**************************************************************************

void visio_file_set(long object, char *selection)
{
gtk_file_selection_set_filename(GTK_FILE_SELECTION(object), selection);
if (visio_debugging) printf ("File in file selection dialog preset.\n");
}

//**************************************************************************

long visio_status_bar(long grid, long xpos, long ypos, long width, long height)
{
GtkWidget *status_bar;
guint context_id;

status_bar = gtk_statusbar_new();
context_id = gtk_statusbar_get_context_id(GTK_STATUSBAR(status_bar),"visio");
gtk_statusbar_push(GTK_STATUSBAR(status_bar),context_id,"");
used_statusbar[sbar_pointer].statusbar = (long)status_bar;
used_statusbar[sbar_pointer].contextid = (long)context_id;
sbar_pointer++;
gtk_table_attach_defaults(GTK_TABLE(grid), status_bar, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show(status_bar);
if (visio_debugging) printf ("Statusbar created.\n");
return ((long)status_bar);
}

//**************************************************************************

void visio_status_set_text(long status_bar, char* tekst)
{
int i;
for (i=1; i<sbar_pointer; i++){
  if (status_bar == used_statusbar[i].statusbar){
    gtk_statusbar_pop(GTK_STATUSBAR(status_bar), used_statusbar[i].contextid);
    gtk_statusbar_push(GTK_STATUSBAR(status_bar),used_statusbar[i].contextid,tekst);
  if (visio_debugging) printf ("Text in statusbar set.\n");
  }
}
}

//**************************************************************************

void visio_tips(long object, char* tekst)
{
gtk_tooltips_set_tip(tooltips, GTK_WIDGET(object), tekst, NULL);
if (visio_debugging) printf ("Tooltip set.\n");
}

//**************************************************************************

long visio_notebook(long grid, long tabpos, long xpos, long ypos, long width, long height)
{
GtkWidget *notebook;

notebook = gtk_notebook_new();
if (tabpos<0||tabpos>3){printf ("\nIllegal tab position value! Quitting...\n");gtk_exit(1);}
switch (tabpos){
case 0: gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_LEFT);break;
case 1: gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_RIGHT);break;
case 2: gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);break;
case 3: gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_BOTTOM);break;
}
gtk_notebook_popup_enable(GTK_NOTEBOOK(notebook));
gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), (gboolean)TRUE);
gtk_table_attach_defaults(GTK_TABLE(grid), notebook, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (notebook);
if (visio_debugging) printf ("Notebook created.\n");
return ((long)notebook);
}

//**************************************************************************

long visio_notebook_page(long notebook, long xsize, long ysize, char *text, long pos)
{
GtkWidget *table;
GtkWidget *label;

table = gtk_table_new(ysize, xsize, TRUE);
label = gtk_label_new(text);
gtk_notebook_insert_page(GTK_NOTEBOOK(notebook), GTK_WIDGET(table), GTK_WIDGET(label), pos);
gtk_widget_show (table);
gtk_widget_show (label);
if (visio_debugging) printf ("Page added to notebook.\n");
return((long)table);
}

//**************************************************************************

void visio_notebook_del_page(long notebook, long pageno)
{
/*Needs integer index value starting at 0*/
gtk_notebook_remove_page(GTK_NOTEBOOK(notebook), pageno);
if (visio_debugging){printf ("Page %d", pageno); printf(" removed from notebook.\n");}
}

//**************************************************************************

long visio_notebook_get_page(long notebook)
{
/*Returns integer index value starting at 0*/
if (visio_debugging) printf ("Current page of notebook fetched.\n");
return(gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)));
}

//**************************************************************************

void visio_notebook_set_page(long notebook, long page)
{
/*Needs integer index value starting at 0*/
gtk_notebook_set_page(GTK_NOTEBOOK(notebook), page);
if (visio_debugging) printf ("Current page of notebook set.\n");
}

//**************************************************************************

void visio_notebook_scroll(long notebook, long show_border)
{
if (show_border==0) gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), (gboolean)FALSE);
else gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), (gboolean)TRUE);
if (visio_debugging) printf ("Scrollable property of notebook set.\n");
}

//**************************************************************************

void visio_notebook_name_page(long notebook, long page, char *text)
{
/*Needs pointer to page*/
gtk_notebook_set_tab_label_text (GTK_NOTEBOOK(notebook), GTK_WIDGET(page), text);
if (visio_debugging) printf ("Notebook pagetext set.\n");
}

//**************************************************************************

void visio_slider_click_callback(GtkWidget *widget, GdkEvent *event, gpointer object)
{
current_object.object = widget;
current_object.state = V_CHANGED;
current_object.mousex = 0;
current_object.mousey = 0;
if (visio_debugging) printf ("Callback reached: slider event.\n");
}

//**************************************************************************

long visio_slider(long grid, long align, long xpos, long ypos, long width, long height)
{
GtkWidget *slider;

//When flag = 0 create horizontal slider with default values
if (align==0) slider = gtk_hscale_new(GTK_ADJUSTMENT(gtk_adjustment_new(0,0,99,1,10,0)));
//Else create vertical slider
else slider = gtk_vscale_new(GTK_ADJUSTMENT(gtk_adjustment_new(0,0,99,1,10,0)));

gtk_signal_connect (GTK_OBJECT (slider), "motion-notify-event", GTK_SIGNAL_FUNC (visio_slider_click_callback), NULL);
gtk_signal_connect (GTK_OBJECT (slider), "button-press-event", GTK_SIGNAL_FUNC (visio_slider_click_callback), NULL);

gtk_scale_set_digits (GTK_SCALE (slider), 0);
gtk_scale_set_draw_value(GTK_SCALE (slider), (gboolean)1 );

gtk_table_attach_defaults(GTK_TABLE(grid), slider, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (slider);
if (visio_debugging) printf ("Slider created.\n");
return ((long)slider);
}

//**************************************************************************

void visio_slider_set(long slider, long value, long lower, long upper, long inc)
{
GtkObject *slider_set;

slider_set = gtk_adjustment_new(value, lower, upper, inc, 0, 0);
gtk_range_set_adjustment (GTK_RANGE(slider),GTK_ADJUSTMENT(slider_set));
if (visio_debugging) printf ("Slider configured.\n");
}

//**************************************************************************

long visio_slider_get(long slider)
{
GtkAdjustment *prop;

prop = gtk_range_get_adjustment(GTK_RANGE(slider));
if (visio_debugging) printf ("Value in slider fetched.\n");
return((long)prop->value);
}

//**************************************************************************

void visio_slider_num(long slider, long align)
{
if (align<0||align>3){printf ("\nIllegal slider position value! Quitting...\n");gtk_exit(1);}
switch (align){
case 0: gtk_scale_set_value_pos(GTK_SCALE (slider), GTK_POS_LEFT);break;
case 1: gtk_scale_set_value_pos(GTK_SCALE (slider), GTK_POS_RIGHT);break;
case 2: gtk_scale_set_value_pos(GTK_SCALE (slider), GTK_POS_TOP);break;
case 3: gtk_scale_set_value_pos(GTK_SCALE (slider), GTK_POS_BOTTOM);break;
}
gtk_scale_set_draw_value(GTK_SCALE (slider), (gboolean)1);
if (visio_debugging) printf ("Value of slider shown.\n");
}

//**************************************************************************

void visio_slider_nonum(long slider)
{
gtk_scale_set_draw_value(GTK_SCALE (slider), (gboolean)0);
if (visio_debugging) printf ("Value of slider hidden.\n");
}

//**************************************************************************

long visio_slider_changed (long slider)
{
if ((long)current_object.object == slider && (long)current_object.state == V_CHANGED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

long visio_progress_bar(long grid, long xpos, long ypos, long width, long height)
{
GtkWidget *probar;

probar = gtk_progress_bar_new();
if (visio_debugging) printf ("Progress bar created.\n");
gtk_table_attach_defaults(GTK_TABLE(grid), probar, xpos, xpos+width, ypos, ypos+height);
gtk_widget_show (probar);
return ((long)probar);
}

//**************************************************************************

void visio_progress_bar_update(long pbar, long perc)

{
gfloat temp;

temp = (gfloat)perc / 100;
if (temp <= 1) gtk_progress_bar_update(GTK_PROGRESS_BAR(pbar), temp);
if (visio_debugging) printf ("Progress bar updated.\n");
}

//**************************************************************************

void visio_progress_bar_orientation (long pbar, long orien)

{
switch (orien){
case 0: gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR(pbar), GTK_PROGRESS_LEFT_TO_RIGHT);break;
case 1: gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR(pbar), GTK_PROGRESS_RIGHT_TO_LEFT);break;
case 2: gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR(pbar), GTK_PROGRESS_TOP_TO_BOTTOM);break;
case 3: gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR(pbar), GTK_PROGRESS_BOTTOM_TO_TOP);break;
}
if (visio_debugging) printf ("Progress bar orientation set.\n");
}

//**************************************************************************

long visio_color(char* title)

{
GtkWidget *color_select;

color_select = gtk_color_selection_dialog_new  (title);
gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (color_select)->ok_button),
				"clicked",GTK_SIGNAL_FUNC(visio_ok_click_callback), GTK_OBJECT(color_select));
gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (color_select)->cancel_button),
				"clicked",GTK_SIGNAL_FUNC(visio_cancel_click_callback), GTK_OBJECT(color_select));
gtk_signal_connect (GTK_OBJECT (GTK_COLOR_SELECTION_DIALOG (color_select)->help_button),
				"clicked",GTK_SIGNAL_FUNC(visio_help_click_callback), GTK_OBJECT(color_select));
if (visio_debugging) printf ("Color selection dialog created.\n");
return ((long)color_select);
}

//**************************************************************************

long visio_color_ok_clicked (long colorsel)
{
if ((long)current_object.object == colorsel && (long)current_object.state == V_OK_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

long visio_color_cancel_clicked (long colorsel)
{
if ((long)current_object.object == colorsel && (long)current_object.state == V_CANCEL_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

long visio_color_help_clicked (long colorsel)
{
if ((long)current_object.object == colorsel && (long)current_object.state == V_HELP_CLICKED) {
        current_object.state = V_NONE;
        return (1);}
return (0);
}

//**************************************************************************

double visio_color_get(long object, long which)

{
gdouble color[3];
GtkWidget *colorselect;

if (which >= 0 && which <= 3){
	colorselect = GTK_COLOR_SELECTION_DIALOG(object) -> colorsel;
	gtk_color_selection_get_color (GTK_COLOR_SELECTION(colorselect), color);
	if (visio_debugging) printf ("RGB value dialog fetched.\n");
	//return (long)(color[which]*65535.0);}
	return (double)(color[which]);}
else{
	if (visio_debugging) printf ("Wrong colorindex passed.\n");
	return (-1);}
}

//**************************************************************************

