MODULE visio

REM***************************************************
REM
REM Often used constants
REM
REM **************************************************

GLOBAL CONST V_FALSE             =    0
GLOBAL CONST V_TRUE              =    1
GLOBAL CONST V_SIZEABLE          =    0
GLOBAL CONST V_FIXED             =    1
GLOBAL CONST V_POS_NONE          =    0
GLOBAL CONST V_POS_CENTRE        =    1
GLOBAL CONST V_POS_MOUSE         =    2
GLOBAL CONST V_JUSTIFY_CENTER      =       0
GLOBAL CONST V_JUSTIFY_LEFT        =       1
GLOBAL CONST V_JUSTIFY_RIGHT       =       2
GLOBAL CONST V_JUSTIFY_FILL        =       3
GLOBAL CONST V_SHADOW_NONE         =       0
GLOBAL CONST V_SHADOW_IN           =       1
GLOBAL CONST V_SHADOW_OUT          =       2
GLOBAL CONST V_SHADOW_ETCHED_IN    =       3
GLOBAL CONST V_SHADOW_ETCHED_OUT   =       4
GLOBAL CONST V_POS_LEFT			=	0
GLOBAL CONST V_POS_RIGHT		=	1
GLOBAL CONST V_POS_TOP			=	2
GLOBAL CONST V_POS_BOTTOM		=	3

REM***************************************************
REM
REM Visio commands
REM
REM **************************************************

REM GENERAL COMMANDS
DECLARE SUB ::debug         ALIAS "__v_debug"               LIB "visio"
DECLARE SUB ::init          ALIAS "__v_init"                LIB "visio"
DECLARE SUB ::wait          ALIAS "__v_wait"                LIB "visio"
DECLARE SUB ::hide          ALIAS "__v_hide"                LIB "visio"
DECLARE SUB ::show          ALIAS "__v_show"                LIB "visio"
DECLARE SUB ::exit          ALIAS "__v_exit"                LIB "visio"
DECLARE SUB ::focus			ALIAS "__v_focus"				LIB "visio"
DECLARE SUB ::font			ALIAS "__v_font"				LIB "visio"
DECLARE SUB ::version		ALIAS "__v_version"				LIB "visio"
DECLARE SUB ::free			ALIAS "__v_free"				LIB "visio"
DECLARE SUB ::enable		ALIAS "__v_enable"				LIB "visio"
DECLARE SUB ::disable		ALIAS "__v_disable"				LIB "visio"

REM WINDOW COMMANDS
DECLARE SUB ::window                ALIAS "__v_window"              LIB "visio"
DECLARE SUB ::window_resized        ALIAS "__v_window_resized"      LIB "visio"
DECLARE SUB ::window_type           ALIAS "__v_window_type"         LIB "visio"
DECLARE SUB ::window_color          ALIAS "__v_window_color"		LIB "visio"

REM GRID COMMANDS
DECLARE SUB ::grid                  ALIAS "__v_grid"                LIB "visio"

REM BUTTON COMMANDS
DECLARE SUB ::button                ALIAS "__v_button"              LIB "visio"
DECLARE SUB ::button_pixmap         ALIAS "__v_button_pixmap"       LIB "visio"
DECLARE SUB ::button_clicked        ALIAS "__v_button_clicked"      LIB "visio"
DECLARE SUB ::button_color			ALIAS "__v_button_color"		LIB "visio"

REM TOGGLE BUTTON COMMANDS
DECLARE SUB ::toggle                ALIAS "__v_toggle"              LIB "visio"
DECLARE SUB ::toggle_pixmap         ALIAS "__v_toggle_pixmap"       LIB "visio"
DECLARE SUB ::toggle_get_status     ALIAS "__v_toggle_get_status"   LIB "visio"
DECLARE SUB ::toggle_set_status     ALIAS "__v_toggle_set_status"   LIB "visio"
DECLARE SUB ::toggle_clicked        ALIAS "__v_button_clicked"      LIB "visio"
DECLARE SUB ::toggle_color			ALIAS "__v_button_color"		LIB "visio"

REM CHECK BUTTON COMMANDS
DECLARE SUB ::check                 ALIAS "__v_check"               LIB "visio"
DECLARE SUB ::check_set_status      ALIAS "__v_check_set_status"    LIB "visio"
DECLARE SUB ::check_get_status      ALIAS "__v_check_get_status"    LIB "visio"
DECLARE SUB ::check_color			ALIAS "__v_button_color"		LIB "visio"

REM TEXTBOX COMMANDS
DECLARE SUB ::textbox               ALIAS "__v_textbox"             LIB "visio"
DECLARE SUB ::textbox_set_text      ALIAS "__v_textbox_set_text"    LIB "visio"
DECLARE SUB ::textbox_get_text      ALIAS "__v_textbox_get_text"    LIB "visio"
DECLARE SUB ::textbox_activated     ALIAS "__v_textbox_activated"   LIB "visio"
DECLARE SUB ::textbox_color			ALIAS "__v_textbox_color"		LIB "visio"

REM LABEL COMMANDS
DECLARE SUB ::label                 ALIAS "__v_label"               LIB "visio"
DECLARE SUB ::label_set_text        ALIAS "__v_label_set_text"      LIB "visio"
DECLARE SUB ::label_get_text        ALIAS "__v_label_get_text"      LIB "visio"
DECLARE SUB ::label_align           ALIAS "__v_label_align"         LIB "visio"
DECLARE SUB ::label_color       	ALIAS "__v_window_color"		LIB "visio"

REM RADIO BUTTON COMMANDS
DECLARE SUB ::radio                 ALIAS "__v_radio"               LIB "visio"
DECLARE SUB ::radio_set_status      ALIAS "__v_radio_set_status"    LIB "visio"
DECLARE SUB ::radio_get_status      ALIAS "__v_radio_get_status"    LIB "visio"
DECLARE SUB ::radio_color			ALIAS "__v_button_color"		LIB "visio"

REM COMBOBOX COMMANDS
DECLARE SUB ::combobox              ALIAS "__v_combobox"            LIB "visio"
DECLARE SUB ::combobox_list         ALIAS "__v_combobox_list"       LIB "visio"
DECLARE SUB ::combobox_set_text     ALIAS "__v_combobox_set_text"   LIB "visio"
DECLARE SUB ::combobox_get_text     ALIAS "__v_combobox_get_text"   LIB "visio"
DECLARE SUB ::combobox_clicked      ALIAS "__v_combobox_clicked"    LIB "visio"

REM MENU COMMANDS
DECLARE SUB ::menu_bar              ALIAS "__v_menu_bar"            LIB "visio"
DECLARE SUB ::menu_bar_color       	ALIAS "__v_window_color"		LIB "visio"
DECLARE SUB ::menu_list             ALIAS "__v_menu_list"           LIB "visio"
DECLARE SUB ::menu_list_color       ALIAS "__v_menu_list_color"     LIB "visio"
DECLARE SUB ::menu_connect          ALIAS "__v_menu_connect"        LIB "visio"
DECLARE SUB ::menu_popup_connect    ALIAS "__v_menu_popup_connect"  LIB "visio"
DECLARE SUB ::menu_clicked          ALIAS "__v_menu_clicked"        LIB "visio"
DECLARE SUB ::menu_separator        ALIAS "__v_menu_separator"      LIB "visio"

REM TEXTEDIT COMMANDS
DECLARE SUB ::edit                  ALIAS "__v_edit"                LIB "visio"
DECLARE SUB ::edit_editable         ALIAS "__v_edit_editable"       LIB "visio"
DECLARE SUB ::edit_set_cursor       ALIAS "__v_edit_set_cursor"     LIB "visio"
DECLARE SUB ::edit_get_cursor       ALIAS "__v_edit_get_cursor"     LIB "visio"
DECLARE SUB ::edit_length           ALIAS "__v_edit_length"         LIB "visio"
DECLARE SUB ::edit_set_text         ALIAS "__v_edit_set_text"       LIB "visio"
DECLARE SUB ::edit_get_text         ALIAS "__v_edit_get_text"       LIB "visio"
DECLARE SUB ::edit_del_text         ALIAS "__v_edit_del_text"       LIB "visio"
DECLARE SUB ::edit_fg_color         ALIAS "__v_edit_fg_color"       LIB "visio"
DECLARE SUB ::edit_bg_color         ALIAS "__v_edit_bg_color"       LIB "visio"
DECLARE SUB ::edit_field_color      ALIAS "__v_edit_field_color"    LIB "visio"

REM FRAME COMMANDS
DECLARE SUB ::frame                 ALIAS "__v_frame"               LIB "visio"
DECLARE SUB ::frame_set_text        ALIAS "__v_frame_set_text"      LIB "visio"
DECLARE SUB ::frame_color           ALIAS "__v_textbox_color"		LIB "visio"

REM SPIN BUTTON COMMANDS
DECLARE SUB ::spin                  ALIAS "__v_spin"                LIB "visio"
DECLARE SUB ::spin_set              ALIAS "__v_spin_set"            LIB "visio"
DECLARE SUB ::spin_get              ALIAS "__v_spin_get"            LIB "visio"
DECLARE SUB ::spin_color      		ALIAS "__v_textbox_color"		LIB "visio"

REM CANVAS COMMANDS
DECLARE SUB ::canvas                ALIAS "__v_canvas"                LIB "visio"
DECLARE SUB ::canvas_clicked        ALIAS "__v_canvas_clicked"        LIB "visio"
DECLARE SUB ::canvas_width          ALIAS "__v_canvas_width"          LIB "visio"
DECLARE SUB ::canvas_height         ALIAS "__v_canvas_height"         LIB "visio"
DECLARE SUB ::canvas_rect           ALIAS "__v_canvas_rect"           LIB "visio"
DECLARE SUB ::canvas_line           ALIAS "__v_canvas_line"           LIB "visio"
DECLARE SUB ::canvas_circle         ALIAS "__v_canvas_circle"         LIB "visio"
DECLARE SUB ::canvas_plot           ALIAS "__v_canvas_plot"           LIB "visio"
DECLARE SUB ::canvas_fg_color       ALIAS "__v_canvas_fg_color"       LIB "visio"
DECLARE SUB ::canvas_bg_color       ALIAS "__v_canvas_bg_color"       LIB "visio"
DECLARE SUB ::canvas_clear          ALIAS "__v_canvas_clear"          LIB "visio"
DECLARE SUB ::canvas_mousex         ALIAS "__v_canvas_mousex"         LIB "visio"
DECLARE SUB ::canvas_mousey         ALIAS "__v_canvas_mousey"         LIB "visio"
DECLARE SUB ::canvas_text         	ALIAS "__v_canvas_text"       	  LIB "visio"
DECLARE SUB ::canvas_popup_connect  ALIAS "__v_canvas_popup_connect"  LIB "visio"
DECLARE SUB ::canvas_del            ALIAS "__v_canvas_del"            LIB "visio"
    
REM FILE SELECTION COMMANDS
DECLARE SUB ::file                  ALIAS "__v_file"                LIB "visio"
DECLARE SUB ::file_ok_clicked       ALIAS "__v_file_ok_clicked"     LIB "visio"
DECLARE SUB ::file_cancel_clicked   ALIAS "__v_file_cancel_clicked" LIB "visio"
DECLARE SUB ::file_get              ALIAS "__v_file_get"            LIB "visio"
DECLARE SUB ::file_set              ALIAS "__v_file_set"            LIB "visio"
DECLARE SUB ::file_color        	ALIAS "__v_window_color"		LIB "visio"

REM STATUSBAR COMMANDS
DECLARE SUB ::status_bar            ALIAS "__v_status_bar"          LIB "visio"
DECLARE SUB ::status_set_text       ALIAS "__v_status_set_text"     LIB "visio"

REM TOOLTIP COMMANDS
DECLARE SUB ::tips                  ALIAS "__v_tips"                LIB "visio"

REM NOTEBOOK COMMANDS
DECLARE SUB ::notebook              ALIAS "__v_notebook"            LIB "visio"
DECLARE SUB ::notebook_page         ALIAS "__v_notebook_page"       LIB "visio"
DECLARE SUB ::notebook_del_page     ALIAS "__v_notebook_del_page"   LIB "visio"
DECLARE SUB ::notebook_get_page     ALIAS "__v_notebook_get_page"   LIB "visio"
DECLARE SUB ::notebook_set_page     ALIAS "__v_notebook_set_page"   LIB "visio"
DECLARE SUB ::notebook_scroll       ALIAS "__v_notebook_scroll"     LIB "visio"
DECLARE SUB ::notebook_name_page    ALIAS "__v_notebook_name_page"  LIB "visio"
DECLARE SUB ::notebook_color        ALIAS "__v_window_color"		LIB "visio"
    
REM SLIDER COMMANDS
DECLARE SUB ::slider				ALIAS "__v_slider"				LIB "visio"
DECLARE SUB ::slider_set			ALIAS "__v_slider_set"			LIB "visio"
DECLARE SUB ::slider_get			ALIAS "__v_slider_get"			LIB "visio"
DECLARE SUB ::slider_num			ALIAS "__v_slider_num"			LIB "visio"
DECLARE SUB ::slider_nonum			ALIAS "__v_slider_nonum"		LIB "visio"
DECLARE SUB ::slider_changed		ALIAS "__v_slider_changed"		LIB "visio"
DECLARE SUB ::slider_color			ALIAS "__v_textbox_color"		LIB "visio"
	
REM PROGRESS BAR COMMANDS
DECLARE SUB ::progress_bar				ALIAS "__v_progress_bar"				LIB "visio"
DECLARE SUB ::progress_bar_update		ALIAS "__v_progress_bar_update"			LIB "visio"
DECLARE SUB ::progress_bar_orientation	ALIAS "__v_progress_bar_orientation"	LIB "visio"
DECLARE SUB ::progress_bar_color		ALIAS "__v_window_color"				LIB "visio"

REM PROGRESS COLOR DIALOG COMMANDS
DECLARE SUB ::color						ALIAS "__v_color"					LIB "visio"
DECLARE SUB ::color_ok_clicked			ALIAS "__v_color_ok_clicked"		LIB "visio"
DECLARE SUB ::color_cancel_clicked		ALIAS "__v_color_cancel_clicked"	LIB "visio"
DECLARE SUB ::color_help_clicked		ALIAS "__v_color_help_clicked"		LIB "visio"
DECLARE SUB ::color_get					ALIAS "__v_color_get"				LIB "visio"
DECLARE SUB ::color_color				ALIAS "__v_window_color"			LIB "visio"

END MODULE
