#include <gtk/gtk.h>

//Define callback signals
#define V_NONE 0
#define V_CLICKED 1
#define V_PRESSED 2
#define V_RELEASED 3
#define V_ACTIVATED 4
#define V_CHANGED 5
#define V_OK_CLICKED 6
#define V_CANCEL_CLICKED 7
#define V_CLICKED_RIGHT 8
#define V_RESIZED 9

//define label alignments
#define V_JUSTIFY_CENTER 0
#define V_JUSTIFY_LEFT 1
#define V_JUSTIFY_RIGHT 2
#define V_JUSTIFY_FILL 3

//define frame shadowing
#define V_SHADOW_NONE 0
#define V_SHADOW_IN 1
#define V_SHADOW_OUT 2
#define V_SHADOW_ETCHED_IN 3
#define V_SHADOW_ETCHED_OUT 4

//Define window types
#define V_SIZEABLE 0
#define V_FIXED 1

//Define window positions
#define V_POS_NONE 0
#define V_POS_CENTRE 1
#define V_POS_MOUSE 2

//Define tab positions of notebook
#define V_POS_LEFT 0
#define V_POS_RIGHT 1
#define V_POS_TOP 2
#define V_POS_BOTTOM 3

//Define current 'callbacked' object
struct callback {GtkWidget *object ; int state; int mousex; int mousey;};

//Define global instance of current callback
struct callback current_object;

//Define global instance of the MAIN window
GtkWidget *main_window;

//Define global debugparameter -> default is NO debugging
int visio_debugging;

//Define array of global radiobutton groups + pointer to current group + last defined button
GSList *radio_button_group[64];
GtkWidget *last_defined_radio_button[256];
int radio_button_group_pointer;

//Define array of global combobox list items + pointer to current list
GList *combo_list[64];
int combo_list_pointer;

//Define array of global menulist items + pointer to current list
GtkWidget *menu_list[64];
int menu_list_pointer;

//Define global pixmaps and drawingareas and colorvariables
struct canvas{GtkWidget *area; GdkPixmap *pixmap;};
struct canvas used_canvas[256];
int canvas_pointer;
GdkGC *gc, *bggc;

//Define global parameters for textcolor in v_edit
GdkColor *text_fg_color;
GdkColor *text_bg_color;

//Define global array of statusbars and contect id's
struct sbar{long statusbar; long contextid;};
struct sbar used_statusbar[64];
int sbar_pointer;

//Define global group of tooltips
GtkTooltips *tooltips;

//General routines*/
extern void visio_debug (long);
extern void visio_init ();
extern void visio_exit ();
extern void visio_wait ();
extern void visio_hide (long);
extern void visio_show (long);
extern void visio_focus (long);
extern void visio_font (long, char*);

//Window routines
extern long visio_window (char*, long, long, long);
extern long visio_window_resized (long);
extern void visio_window_type (long, long);

//Grid routines
extern long visio_grid (long, long, long);

//Button routines
extern long visio_button (long, long, long, long, long, char*);
extern long visio_button_clicked (long);

//Toggle button routines
extern long visio_toggle (long, long, long, long, long, char*);
extern void visio_toggle_set_status (long, int);
extern long visio_toggle_get_status (long);

//Check button routines
extern long visio_check (long, long, long, long, long, char*);
extern void visio_check_set_status (long, int);
extern long visio_check_get_status (long);

//Textbox routines
extern long visio_textbox (long, long, long, long, long);
extern void visio_textbox_set_text (long, char*);
extern char* visio_textbox_get_text (long);
extern long visio_textbox_activated (long);

//Label routines
extern long visio_label (long, long, long, long, long, char*);
extern void visio_label_set_text(long, char*);
extern char* visio_label_get_text (long);
extern void visio_label_align (long, long);

//Radio button routines
extern long visio_radio (long, long, long, long, long, long, char*);
extern void visio_radio_set_status (long, int);
extern long visio_radio_get_status(long);

//Combo box routines
extern long visio_combobox (long, long, long, long, long, long);
extern void visio_combobox_list (long, char*);
extern void visio_combobox_set_text (long, char*);
extern char* visio_combobox_get_text (long);
extern long visio_combobox_clicked (long);

//Menu routines
extern long visio_menu_bar (long, long, long, long, long);
extern long visio_menu_list (long, char*);
extern void visio_menu_connect (long, long, char*);
extern void visio_menu_popup_connect (long, long);
extern long visio_menu_clicked (long);

//Edit routines
extern long visio_edit (long, long, long, long, long);
extern void visio_edit_editable (long, long);
extern void visio_edit_set_cursor (long, long);
extern long visio_edit_get_cursor (long);
extern long visio_edit_length (long);
extern void visio_edit_set_text (long, char*, char*);
extern char* visio_edit_get_text (long);
extern long visio_edit_del_text(long, long);
extern void visio_edit_fg_color(long, long, long);

//Frame routines
extern long visio_frame (long, long, long, long, long, long);
extern void visio_frame_set_text (long, char*);

//Spinbutton routines
extern long visio_spin (long, long, long, long, long);
extern void visio_spin_set (long, long, long, long, long);
extern long visio_spin_get (long);

//Canvas routines
extern long visio_canvas (long, long, long, long, long);
extern long visio_canvas_width (long);
extern long visio_canvas_height (long);
extern void visio_canvas_rect (long, long, long, long, long, long);
extern void visio_canvas_line (long, long, long, long, long);
extern void visio_canvas_circle (long, long, long, long, long, long);
extern void visio_canvas_plot (long, long, long);
extern void visio_canvas_fg_color (long, long, long);
extern void visio_canvas_bg_color (long, long, long);
extern void visio_canvas_clear (long);
extern long visio_canvas_clicked (long);
extern long visio_canvas_mousex (long);
extern long visio_canvas_mousey (long);

//File Selection routines
extern long visio_file (char*);
extern long visio_file_ok_clicked (long);
extern long visio_file_cancel_clicked (long);
extern char* visio_file_get (long);
extern void visio_file_set (long, char*);

//Statusbar routines
extern long visio_status_bar (long, long, long, long, long);
extern void visio_status_set_text (long, char*);

//Tooltip routines
extern void visio_tips (long, char*);

//Notebook routines
extern long visio_notebook (long, long, long, long, long, long);
extern long visio_notebook_page (long, long, long, char*, long);
extern void visio_notebook_del (long, long);
extern long visio_notebook_get_page (long);
extern void visio_notebook_set_page (long, long);
extern void visio_notebook_scroll (long, long);

//Slider routines
extern long visio_slider (long, long, long, long, long, long);
extern void visio_slider_set (long, long, long, long, long);
extern long visio_slider_get (long);
extern void visio_slider_num (long, long);
extern void visio_slider_nonum (long);
