#include <stdio.h>
#include <stdlib.h>
#include "../../basext.h"
#include <string.h>
#include <errno.h>
#include <sys/types.h>

#ifdef LINUX
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#endif

#ifdef WIN32
#include <winsock.h>
#endif

#define MAXDATASIZE 8192

int ssocket_debugging;
int raw_data_pointer;
char* raw_data[64];
int raw_amount[64];
char* last_client;

/*
** Translation Table as described in RFC1113
*/
static const char cb64[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*
** Translation Table to decode (created by author)
*/
static const char cd64[]="|$$$}rstuvwxyz{$$$$$$$>?@ABCDEFGHIJKLMNOPQRSTUVW$$$$$$XYZ[\\]^_`abcdefghijklmnopq";


besVERSION_NEGOTIATE
    return (int)INTERFACE_VERSION;
besEND

besSUB_START
	#ifdef WIN32	
	WSADATA wsaData;
	if (WSAStartup(MAKEWORD(2, 0), &wsaData) != 0) printf("WSAStartup() failed.");
	#endif
	ssocket_debugging = 0;
	raw_data_pointer = 0;

besEND

besSUB_FINISH
	#ifdef WIN32
	WSACleanup();
	#endif	
besEND

besFUNCTION (__ss_version)
	
	if(besARGNR > 0) return EX_ERROR_TOO_MANY_ARGUMENTS;
	
	printf ("Simple Socket module version 3b loaded.\n");
	printf ("Released november 5, 2002.\n");

	besRETURNVALUE = NULL;
besEND

besFUNCTION (__ss_debug)
	VARIABLE ptr;
	long arg0;

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	if (arg0 == 1) {ssocket_debugging = 1; printf ("Debugging on.\n");}
	else {ssocket_debugging = 0; printf("Debugging off.\n");}

	besRETURNVALUE = NULL;
besEND

besFUNCTION (__ss_connect)
	VARIABLE ptr;
	char* arg0;
	long arg1;
	int sockfd;
	struct hostent *he;
	struct sockaddr_in their_addr;					// connector's address information

	if(besARGNR<2) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>2) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg0);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besGETLONGVALUE(ptr);

	sockfd = 0;

	if ((he=gethostbyname(arg0)) == NULL) {  			// get the host info
		if (ssocket_debugging){
			printf ("\nSpecified host does not exist!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -1;
	}

	else if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		if (ssocket_debugging){
			printf("\nCannot setup STREAM socket!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -2;
		}

		else {
			their_addr.sin_family = AF_INET;    				// host byte order
			their_addr.sin_port = htons(arg1);					// short, network byte order
			their_addr.sin_addr = *((struct in_addr *)he->h_addr);
			memset(&(their_addr.sin_zero), '\0', 8);			// zero the rest of the struct

			if (connect(sockfd, (struct sockaddr *)&their_addr, sizeof(struct sockaddr)) == -1) {
				if (ssocket_debugging){
					printf("Unable to connect to specified host!\n");
					printf("System message: %s\n",strerror(errno));}
				sockfd = -3;
			}
			else if (ssocket_debugging) printf("Socket connected.\n");
			}
	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = sockfd;

	besFREE (arg0);
besEND

besFUNCTION (__ss_disconnect)
	VARIABLE ptr;
	long arg0, result;

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	#ifdef WIN32
	result = closesocket(arg0);
	#endif
	#ifdef LINUX
	result = close(arg0);
	#endif

	raw_data_pointer = 0;
	if (ssocket_debugging){
		printf("Socket disconnected.\n");
		printf("Result of close is: %d\n", result);
		printf("System message: %s\n",strerror(errno));
		printf("Raw data pointer set to 0.\n");}

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = result;
besEND

besFUNCTION (__ss_check)
	VARIABLE ptr;
	long arg0;
	fd_set read_available;
	struct timeval tv;
	int returnvalue;

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	returnvalue = 0;

	FD_ZERO(&read_available);
	FD_SET(arg0, &read_available);

	tv.tv_sec = 0;
	tv.tv_usec = 0;
	select(arg0+1, &read_available, NULL, NULL, &tv);

	if (FD_ISSET(arg0, &read_available)){
		if (ssocket_debugging) printf("There is new data.\n");
		returnvalue = 1;
	}

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = returnvalue;
besEND

besFUNCTION (__ss_read)
	VARIABLE ptr;
	long arg0, arg1;
	int numbytes;
	char buf[MAXDATASIZE];
	char* retstr;

	if(besARGNR < 2) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR > 2) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besGETLONGVALUE(ptr);
										//STREAM
	if(arg1 == 0){

		numbytes = recv(arg0, buf, MAXDATASIZE-1, 0);

		if (numbytes == -1) {
			if (ssocket_debugging){
				printf("Error reading from socket!\n");
				printf("System message: %s\n",strerror(errno));}
			retstr = "SIMPLE SOCKET ERROR 1";
		}

		else if (numbytes == 0){
			if (ssocket_debugging){
				printf("Remote side has closed connection.\n");
				printf("System message: %s\n",strerror(errno));}
			retstr = "SIMPLE SOCKET ERROR 2";
		}

		else {
			buf[numbytes] = '\0';
			retstr = (char*)buf;
			if (ssocket_debugging) printf("Data read.\n");
		}

		besALLOC_RETURN_STRING(strlen(retstr));
		memcpy(STRINGVALUE(besRETURNVALUE),retstr,strlen(retstr));}
										//RAW
	else if (arg1 == 1){

		numbytes = recv(arg0, buf, MAXDATASIZE, 0);

		if (numbytes == -1){
     		if (ssocket_debugging){
				printf("Error reading from socket!\n");
				printf("System message: %s\n",strerror(errno));}
			raw_data_pointer = -1;
		}

		else if (numbytes == 0){
     		if (ssocket_debugging){
				printf("Remote side has closed connection.\n");
				printf("System message: %s\n",strerror(errno));}
			raw_data_pointer = -2;
		}

		else {
			if (ssocket_debugging) printf("RAW data read.\n");
			raw_data_pointer++;
			if (raw_data_pointer == 64) raw_data_pointer = 0;
			if (ssocket_debugging) printf("Raw data pointer set to: %d\n", raw_data_pointer);
			raw_amount[raw_data_pointer] = numbytes;
			raw_data[raw_data_pointer] = (char*)buf;
		}

		besALLOC_RETURN_LONG;
		LONGVALUE(besRETURNVALUE) = raw_data_pointer;}
besEND

besFUNCTION (__ss_write)
	VARIABLE ptr;
	long arg0, arg2, arg3, bytes_sent;
	char* arg1;

	if(besARGNR<3) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>3) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	ptr = besARGUMENT(3);
	besDEREFERENCE(ptr);
	arg2 = besGETLONGVALUE(ptr);

	if (arg2 == 0){

		ptr = besARGUMENT(2);
		besDEREFERENCE(ptr);
		arg1 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg1);

		bytes_sent = send(arg0, arg1, strlen(arg1), 0);

		if (bytes_sent < strlen(arg1)){
			if (ssocket_debugging) printf("Some bytes were lost!\n");
		}

		if (ssocket_debugging) printf("Data sent.\n");

		besALLOC_RETURN_LONG;
		LONGVALUE(besRETURNVALUE) = bytes_sent;

		besFREE (arg1);}

	else if (arg2 == 1) {

		ptr = besARGUMENT(2);
		besDEREFERENCE(ptr);
		arg3 = besGETLONGVALUE(ptr);

		bytes_sent = send(arg0, raw_data[arg3], raw_amount[arg3], 0);

		if (bytes_sent < 0){
			if (ssocket_debugging){
				printf("An error occurred!\n");
				printf("System message: %s\n",strerror(errno));}
		}

		if (ssocket_debugging) printf("RAW data sent.\n");

		besALLOC_RETURN_LONG;
		LONGVALUE(besRETURNVALUE) = bytes_sent;
		}
besEND

besFUNCTION (__ss_server)
	VARIABLE ptr;
	char* arg0;
	long arg1, arg2;
	int sockfd;
	int yes = 1;
	struct hostent *he;
	struct sockaddr_in my_addr;					// my address information

	if(besARGNR<3) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>3) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg0);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besGETLONGVALUE(ptr);

	ptr = besARGUMENT(3);
	besDEREFERENCE(ptr);
	arg2 = besGETLONGVALUE(ptr);

	sockfd = 0;

	if ((he=gethostbyname(arg0)) == NULL) {  			// get the host info
		if (ssocket_debugging){
			printf ("\nSpecified host does not exist!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -1;
	}

	else if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		if (ssocket_debugging){
			printf("\nCannot connect to socket!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -2;
	}

	else if (setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,&yes,sizeof(int)) == -1) {
		if (ssocket_debugging){
			printf("\nCannot configure socket!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -3;
	}

	else {
		my_addr.sin_family = AF_INET;
		my_addr.sin_port = htons(arg1);     					// Fill in specified port
		my_addr.sin_addr = *((struct in_addr *)he->h_addr);		// Fill in specified IP address
		memset(&(my_addr.sin_zero), '\0', 8);					// zero the rest of the struct

		if (bind(sockfd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) {
			if (ssocket_debugging){
				printf("Unable to bind the specified socket address!\n");
				printf("System message: %s\n",strerror(errno));}
			sockfd = -4;
          }

		else if (listen(sockfd, arg2) == -1) {
			if (ssocket_debugging){
				printf("Unable to listen to the specified socket address!\n");
				printf("System message: %s\n",strerror(errno));}
			sockfd = -5;
          }
		else if (ssocket_debugging) printf("Server started.\n");
          }

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = sockfd;

	besFREE (arg0);
besEND

besFUNCTION (__ss_accept)
	VARIABLE ptr;
	long arg0;
	int sin_size, new_fd;
	struct sockaddr_in their_addr; // connector's address information

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	sin_size = sizeof(struct sockaddr_in);
	if ((new_fd = accept(arg0, (struct sockaddr *)&their_addr, &sin_size)) == -1) {
		if (ssocket_debugging){
			printf("No connection made!\n");
			printf("System message: %s\n",strerror(errno));}
		new_fd = -1;
	}
	
	last_client = (char*)inet_ntoa(their_addr.sin_addr);
	if (ssocket_debugging){
		printf("Got connection from ");
		printf(last_client); printf ("\n");}

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = new_fd;
besEND

besFUNCTION (__ss_lastclient)

	if(besARGNR>0) return EX_ERROR_TOO_MANY_ARGUMENTS;

	besALLOC_RETURN_STRING(strlen(last_client));
	memcpy(STRINGVALUE(besRETURNVALUE), last_client, strlen(last_client));

besEND

/*
** encodeblock
**
** encode 3 8-bit binary bytes as 4 '6-bit' characters
*/
void encodeblock( unsigned char in[3], unsigned char out[4], int len )
{
    out[0] = cb64[ in[0] >> 2 ];
    out[1] = cb64[ ((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4) ];
    out[2] = (unsigned char) (len > 1 ? cb64[ ((in[1] & 0x0f) << 2) | ((in[2] & 0xc0) >> 6) ] : '=');
    out[3] = (unsigned char) (len > 2 ? cb64[ in[2] & 0x3f ] : '=');
}

/*
** encode
**
** base64 encode a stream adding padding and line breaks as per spec.
*/
besFUNCTION (__ss_b64_encode)

	VARIABLE ptr;
	int i, len, cur = 0;
	char* arg0;
	char* encoded;
    unsigned char in[3], out[4];

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg0);

	while (cur <= strlen(arg0)){
		len = 0;
        for (i = 0; i < 3; i++){
            in[i] = arg0[cur + i];
            if(cur + i != strlen(arg0)){
				len++;}
			else{
				in[i] = 0;}
		}
		printf ("len: %d\n", len);
        if (len){
            encodeblock(in, out, len);
            for(i = 0; i < 4; i++) {
                encoded = &out[i];
				encoded++;}
            }
		cur += len;
		printf ("cur: %d\n", cur);
	}
	
	while (cur > 0) {
		encoded--;
		cur--;
	}
	
	besALLOC_RETURN_STRING(strlen(encoded));
	memcpy(STRINGVALUE(besRETURNVALUE), encoded, strlen(encoded));

besEND

/*    while( !feof( infile ) ) {
        len = 0;
        for( i = 0; i < 3; i++ ) {
            in[i] = (unsigned char) getc( infile );
            if( !feof( infile ) ) {
                len++;
            }
            else {
                in[i] = 0;
            }
        }

        if( len ) {
            encodeblock( in, out, len );
            for( i = 0; i < 4; i++ ) {
                putc( out[i], outfile );
            }
            blocksout++;
        }
        if( blocksout >= (linesize/4) || feof( infile ) ) {
            if( blocksout ) {
                fprintf( outfile, "\r\n" );
            }
            blocksout = 0;
        }
    }
}*/


/*
** decodeblock
**
** decode 4 '6-bit' characters into 3 8-bit binary bytes
*/
/*void decodeblock( unsigned char in[4], unsigned char out[3] )
{   
    out[ 0 ] = (unsigned char ) (in[0] << 2 | in[1] >> 4);
    out[ 1 ] = (unsigned char ) (in[1] << 4 | in[2] >> 2);
    out[ 2 ] = (unsigned char ) (((in[2] << 6) & 0xc0) | in[3]);
}*/

/*
** decode
**
** decode a base64 encoded stream discarding padding, line breaks and noise
*/
/*void decode( FILE *infile, FILE *outfile )
{
    unsigned char in[4], out[3], v;
    int i, len;

    while( !feof( infile ) ) {
        for( len = 0, i = 0; i < 4 && !feof( infile ); i++ ) {
            v = 0;
            while( !feof( infile ) && v == 0 ) {
                v = (unsigned char) getc( infile );
                v = (unsigned char) ((v < 43 || v > 122) ? 0 : cd64[ v - 43 ]);
                if( v ) {
                    v = (unsigned char) ((v == '$') ? 0 : v - 61);
                }
            }
            if( !feof( infile ) ) {
                len++;
                if( v ) {
                    in[ i ] = (unsigned char) (v - 1);
                }
            }
            else {
                in[i] = 0;
            }
        }
        if( len ) {
            decodeblock( in, out );
            for( i = 0; i < len - 1; i++ ) {
                putc( out[i], outfile );
            }
        }
    }
}
*/


SLFST SSOCKET_SLFST[]={

{"versmodu", versmodu},
{"bootmodu", bootmodu},
{"finimodu", finimodu},
{"__ss_debug", __ss_debug},
{"__ss_version", __ss_version},
{"__ss_connect", __ss_connect},
{"__ss_disconnect", __ss_disconnect},
{"__ss_check", __ss_check},
{"__ss_read", __ss_read},
{"__ss_write", __ss_write},
{"__ss_server", __ss_server},
{"__ss_accept", __ss_accept},
{"__ss_lastclient", __ss_lastclient},
{NULL, NULL}
};

