#include <stdio.h>
#include <stdlib.h>
#include "../../basext.h"
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>

#define MAXDATASIZE 16384

int ssocket_debugging;
int raw_data_pointer;
char* raw_data[256];
int raw_amount[256];
char* last_client;

besVERSION_NEGOTIATE
    return (int)INTERFACE_VERSION;
besEND

besSUB_START
	ssocket_debugging = 0;
	raw_data_pointer = 0;
besEND

besSUB_FINISH
besEND

besFUNCTION (__ss_version)
	
	if(besARGNR > 0) return EX_ERROR_TOO_MANY_ARGUMENTS;
	
	printf ("Simple Socket module version 3 loaded.\n");
	printf ("Released november 4, 2002.\n");

	besRETURNVALUE = NULL;
besEND

besFUNCTION (__ss_debug)
	VARIABLE ptr;
	long arg0;

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	if (arg0 == 1) {ssocket_debugging = 1; printf ("Debugging on.\n");}
	else {ssocket_debugging = 0; printf("Debugging off.\n");}

	besRETURNVALUE = NULL;
besEND

besFUNCTION (__ss_connect)
	VARIABLE ptr;
	char* arg0;
	long arg1;
	int sockfd;
	struct hostent *he;
	struct sockaddr_in their_addr;					// connector's address information

	if(besARGNR<2) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>2) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg0);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besGETLONGVALUE(ptr);

	sockfd = 0;

	if ((he=gethostbyname(arg0)) == NULL) {  			// get the host info
		if (ssocket_debugging){
			printf ("\nSpecified host does not exist!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -1;
	}

	else if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		if (ssocket_debugging){
			printf("\nCannot setup STREAM socket!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -2;
		}

		else {
			their_addr.sin_family = AF_INET;    				// host byte order
			their_addr.sin_port = htons(arg1);					// short, network byte order
			their_addr.sin_addr = *((struct in_addr *)he->h_addr);
			memset(&(their_addr.sin_zero), '\0', 8);			// zero the rest of the struct

			if (connect(sockfd, (struct sockaddr *)&their_addr, sizeof(struct sockaddr)) == -1) {
				if (ssocket_debugging){
					printf("Unable to connect to specified host!\n");
					printf("System message: %s\n",strerror(errno));}
				sockfd = -3;
			}
			else if (ssocket_debugging) printf("Socket connected.\n");
			}
	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = sockfd;

	besFREE (arg0);
besEND

besFUNCTION (__ss_disconnect)
	VARIABLE ptr;
	long arg0;

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	close(arg0);
	raw_data_pointer = 0;
	if (ssocket_debugging){
		printf("Socket disconnected.\n");
		printf("Raw data pointer set to 0.\n");}

	besRETURNVALUE = NULL;
besEND

besFUNCTION (__ss_check)
	VARIABLE ptr;
	long arg0;
	fd_set read_available;
	struct timeval tv;
	int returnvalue;

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	returnvalue = 0;

	FD_ZERO(&read_available);
	FD_SET(arg0, &read_available);

	tv.tv_sec = 0;
	tv.tv_usec = 0;
	select(arg0+1, &read_available, NULL, NULL, &tv);

	if (FD_ISSET(arg0, &read_available)){
		if (ssocket_debugging) printf("There is new data.\n");
		returnvalue = 1;
	}

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = returnvalue;
besEND

besFUNCTION (__ss_read)
     VARIABLE ptr;
	long arg0;
	int numbytes;
	char buf[MAXDATASIZE];
     char* retstr;

     if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
     if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	numbytes = recv(arg0, buf, MAXDATASIZE-1, 0);

     if (numbytes == -1) {
     	if (ssocket_debugging){
			printf("Error reading from socket!\n");
			printf("System message: %s\n",strerror(errno));}
		retstr = "SIMPLE SOCKET ERROR 1";
	}

	else if (numbytes == 0){
     	if (ssocket_debugging){
			printf("Remote side has closed connection.\n");
			printf("System message: %s\n",strerror(errno));}
		retstr = "SIMPLE SOCKET ERROR 2";
	}

	else {
		buf[numbytes] = '\0';
		retstr = (char*)buf;
		if (ssocket_debugging) printf("Data read.\n");
	}

	besALLOC_RETURN_STRING(strlen(retstr));
	memcpy(STRINGVALUE(besRETURNVALUE),retstr,strlen(retstr));
besEND

besFUNCTION (__ss_read_raw)
     VARIABLE ptr;
	long arg0;
	int numbytes;
	char buf[MAXDATASIZE];

     if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
     if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	numbytes = recv(arg0, buf, MAXDATASIZE, 0);

     if (numbytes == -1){
     	if (ssocket_debugging){
			printf("Error reading from socket!\n");
			printf("System message: %s\n",strerror(errno));}
		raw_data_pointer = -1;
	}

	else if (numbytes == 0){
     	if (ssocket_debugging){
			printf("Remote side has closed connection.\n");
			printf("System message: %s\n",strerror(errno));}
		raw_data_pointer = -2;
	}

	else {
		if (ssocket_debugging) printf("RAW data read.\n");
		raw_data_pointer++;
		if (ssocket_debugging) printf("Raw data pointer set to: %d\n", raw_data_pointer);
		raw_amount[raw_data_pointer] = numbytes;
		raw_data[raw_data_pointer] = (char*)buf;
	}

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = raw_data_pointer;
besEND

besFUNCTION (__ss_write)
	VARIABLE ptr;
	long arg0, bytes_sent;
	char* arg1;

	if(besARGNR<2) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>2) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg1);

	bytes_sent = send(arg0, arg1, strlen(arg1), 0);

	if (bytes_sent < strlen(arg1)){
		if (ssocket_debugging) printf("Some bytes were lost!\n");
	}

	if (ssocket_debugging) printf("Data sent.\n");

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = bytes_sent;

	besFREE (arg1);
besEND

besFUNCTION (__ss_write_raw)
	VARIABLE ptr;
	long arg0, arg1, bytes_sent;

	if(besARGNR<2) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>2) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besGETLONGVALUE(ptr);

	bytes_sent = send(arg0, raw_data[arg1], raw_amount[arg1], 0);

	if (bytes_sent < 0){
		if (ssocket_debugging){
			printf("An error occurred!\n");
			printf("System message: %s\n",strerror(errno));}
	}

	if (ssocket_debugging) printf("RAW data sent.\n");
	raw_data_pointer--;
	if (ssocket_debugging) printf("Raw data pointer set to: %d\n", raw_data_pointer);

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = bytes_sent;
besEND

besFUNCTION (__ss_server)
	VARIABLE ptr;
	char* arg0;
	long arg1, arg2;
	int sockfd;
	int yes = 1;
	struct hostent *he;
	struct sockaddr_in my_addr;					// my address information

	if(besARGNR<3) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>3) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besCONVERT2ZCHAR(besCONVERT2STRING(ptr),arg0);

	ptr = besARGUMENT(2);
	besDEREFERENCE(ptr);
	arg1 = besGETLONGVALUE(ptr);

	ptr = besARGUMENT(3);
	besDEREFERENCE(ptr);
	arg2 = besGETLONGVALUE(ptr);

	sockfd = 0;

	if ((he=gethostbyname(arg0)) == NULL) {  			// get the host info
		if (ssocket_debugging){
			printf ("\nSpecified host does not exist!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -1;
	}

	else if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		if (ssocket_debugging){
			printf("\nCannot connect to socket!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -2;
	}

	else if (setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,&yes,sizeof(int)) == -1) {
		if (ssocket_debugging){
			printf("\nCannot configure socket!\n");
			printf("System message: %s\n",strerror(errno));}
		sockfd = -3;
	}

	else {
		my_addr.sin_family = AF_INET;
		my_addr.sin_port = htons(arg1);     					// Fill in specified port
		my_addr.sin_addr = *((struct in_addr *)he->h_addr);		// Fill in specified IP address
		memset(&(my_addr.sin_zero), '\0', 8);					// zero the rest of the struct

		if (bind(sockfd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) {
			if (ssocket_debugging){
				printf("Unable to bind the specified socket address!\n");
				printf("System message: %s\n",strerror(errno));}
			sockfd = -4;
          }

		else if (listen(sockfd, arg2) == -1) {
			if (ssocket_debugging){
				printf("Unable to listen to the specified socket address!\n");
				printf("System message: %s\n",strerror(errno));}
			sockfd = -5;
          }
		else if (ssocket_debugging) printf("Server started.\n");
          }

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = sockfd;

	besFREE (arg0);
besEND

besFUNCTION (__ss_accept)
	VARIABLE ptr;
	long arg0;
	int sin_size, new_fd;
	struct sockaddr_in their_addr; // connector's address information

	if(besARGNR<1) return EX_ERROR_TOO_FEW_ARGUMENTS;
	if(besARGNR>1) return EX_ERROR_TOO_MANY_ARGUMENTS;

	ptr = besARGUMENT(1);
	besDEREFERENCE(ptr);
	arg0 = besGETLONGVALUE(ptr);

	sin_size = sizeof(struct sockaddr_in);
	if ((new_fd = accept(arg0, (struct sockaddr *)&their_addr, &sin_size)) == -1) {
		if (ssocket_debugging){
			printf("No connection made!\n");
			printf("System message: %s\n",strerror(errno));}
		new_fd = -1;
	}
	
	last_client = (char*)inet_ntoa(their_addr.sin_addr);
	if (ssocket_debugging){
		printf("Got connection from ");
		printf(last_client); printf ("\n");}

	besALLOC_RETURN_LONG;
	LONGVALUE(besRETURNVALUE) = new_fd;
besEND

besFUNCTION (__ss_lastclient)

	if(besARGNR>0) return EX_ERROR_TOO_MANY_ARGUMENTS;

	besALLOC_RETURN_STRING(strlen(last_client));
	memcpy(STRINGVALUE(besRETURNVALUE), last_client, strlen(last_client));

besEND

SLFST SSOCKET_SLFST[]={

{"versmodu", versmodu},
{"bootmodu", bootmodu},
{"finimodu", finimodu},
{"__ss_debug", __ss_debug},
{"__ss_version", __ss_version},
{"__ss_connect", __ss_connect},
{"__ss_disconnect", __ss_disconnect},
{"__ss_check", __ss_check},
{"__ss_read", __ss_read},
{"__ss_read_raw", __ss_read_raw},
{"__ss_write", __ss_write},
{"__ss_write_raw", __ss_write_raw},
{"__ss_server", __ss_server},
{"__ss_accept", __ss_accept},
{"__ss_lastclient", __ss_lastclient},
{NULL, NULL}
};
